/*
Replication syntax for:

Weber, Till. 2021. Themensetzung, Bevölkerungsstruktur und Stimmenpotenziale.
In: Schoen, Harald, and Bernhard Weßels (eds.) Wahlen und Wähler.
Analysen aus Anlass der Bundestagswahl 2017. Wiesbaden: Springer VS.

till.weber@baruch.cuny.edu
*/

cd your_directory_here

clear all
use "GLES 2005-2009-2013\ZA5321_v2-1-0.dta" // This is the GLES panel 2005-2009-2013.
replace fschicht = . if fschicht>6
keep lfdn fschicht
rename lfdn lfdn_LFP05
save "files\panel050913ready.dta", replace

clear all
use "GLES 2009-2013-2017\ZA5322_v1-1-0.dta" // This is the GLES panel 2009-2013-2017.
run "GLES 2009-2013-2017\ZA5322_RecodeMissings.do"
replace fschicht = . if fschicht<0
keep lfdn fschicht
rename lfdn lfdn_LFP09
save "files\panel091317ready.dta", replace

clear all
use "GLES 2013\ZA5702_v3-0-0_de.dta" // This is the GLES 2013.
run "GLES 2013\ZA5702_missing_de.do"
keep lfdn vn192
rename vn192 fschicht
rename lfdn lfdn_QS13
save "files\panel131721ready.dta", replace

clear all
use "GLES 2016\ZA5760_v1-0-0.dta" // This is the GLES 2016 for the 2005, 2009 and 2013 panels.
run "GLES 2016\ZA5760_missing.do"
replace lfdn_LFP05 = _n*100000 if mi(lfdn_LFP05)
merge 1:1 lfdn_LFP05 using "files\panel050913ready.dta"
drop if _merge==2
drop _merge
replace lfdn_LFP09 = _n*100000 if mi(lfdn_LFP09)
merge 1:1 lfdn_LFP09 using "files\panel091317ready.dta", update
drop if _merge==2
drop _merge
replace lfdn_QS13 = _n*100000 if mi(lfdn_QS13)
merge 1:1 lfdn_QS13 using "files\panel131721ready.dta", update
drop if _merge==2
drop _merge
rename m64a votint
replace votint = -97 if mi(votint)
rename msex gender
gen age = 2016-mjahr
rename fschicht class
replace class = . if class<0
recode class (1 2 3=0) (4 5 6=1), gen(classbin)
foreach var of varlist m580j-m580c m170m-m580l m580m-m580q {
	recode `var' (1 2=0) (3=.5) (4 5=1), gen(iss_`var')
}
recode m174b (1 2 3 4 5=0) (6=.5) (7 8 9 10 11=1), gen(iss_m174b)
include iyield.ado // This is a convenience program by Lorenzo De Sio.
gen weight = (29.8/(29.8+31.7))/(1000/(1000+822)) if gender==1
replace weight = (31.7/(31.7+29.8))/(822/(822+1000)) if gender==2
iyield iss* using "files\yield_global.dta", groupby(votint) weight(weight) replace
bysort gender: iyield iss* using "files\yield_gender.dta", groupby(votint) weight(weight) replace
bysort classbin: iyield iss* using "files\yield_class.dta", groupby(votint) weight(weight) replace

clear all
use "files\yield_global.dta"
gen global = 1
append using "files\yield_gender.dta"
append using "files\yield_class.dta"
drop if party==-97 | party==801
keep sign party issvar yield global gender classbin
egen policy = group(issvar sign)
gen aux1 = yield if gender==1
gen aux2 = yield if gender==2
bysort issvar sign party: egen yield_male = mean(aux1)
bysort issvar sign party: egen yield_female = mean(aux2)
drop aux*
gen aux1 = yield if class==0
gen aux2 = yield if class==1
bysort issvar sign party: egen yield_lower = mean(aux1)
bysort issvar sign party: egen yield_upper = mean(aux2)
drop aux*
drop if global!=1
merge m:1 party using cmp.dta, nogen // This is the excerpt for Germany 2017 from MARPOR 2018a.
gen emph = .
replace emph = per503 if issvar=="iss_m580j" & sign=="pos"
replace emph = per202_4 if issvar=="iss_m580e" & sign=="pos"
replace emph = per608_2 if issvar=="iss_m580a" & sign=="pos"
replace emph = per503 if issvar=="iss_m580g" & sign=="pos"
replace emph = per401 if issvar=="iss_m580c" & sign=="pos"
replace emph = (per601_1 + per606_1)/2 if issvar=="iss_m170m" & sign=="pos"
replace emph = per608_1 if issvar=="iss_m580h" & sign=="pos"
replace emph = (per503 + per604)/2 if issvar=="iss_m170dd" & sign=="pos"
replace emph = per605_1 if issvar=="iss_m580k" & sign=="pos"
replace emph = per605_1 if issvar=="iss_m580l" & sign=="pos"
replace emph = per201_2 if issvar=="iss_m580n" & sign=="pos"
replace emph = per108 if issvar=="iss_m580d" & sign=="pos"
replace emph = per504 if issvar=="iss_m580p" & sign=="pos"
replace emph = per601_2 if issvar=="iss_m174b" & sign=="pos"
replace emph = per402 if issvar=="iss_m580j" & sign=="neg"
replace emph = per501 if issvar=="iss_m580f" & sign=="neg"
replace emph = per607_2 if issvar=="iss_m580a" & sign=="neg"
replace emph = per602_1 if issvar=="iss_m170m" & sign=="neg"
replace emph = per607_1 if issvar=="iss_m580h" & sign=="neg"
replace emph = per603 if issvar=="iss_m170dd" & sign=="neg"
replace emph = per605_2 if issvar=="iss_m580k" & sign=="neg"
replace emph = per605_2 if issvar=="iss_m580l" & sign=="neg"
replace emph = per201_2 if issvar=="iss_m580m" & sign=="neg"
replace emph = per201_2 if issvar=="iss_m580o" & sign=="neg"
replace emph = per110 if issvar=="iss_m580d" & sign=="neg"
replace emph = per505 if issvar=="iss_m580p" & sign=="neg"
replace emph = per401 if issvar=="iss_m580q" & sign=="neg"
replace emph = per602_2 if issvar=="iss_m174b" & sign=="neg"
drop if emph==.
reg yield_male yield_female
predict res_male, res
reg yield_female yield_male
predict res_female, res
reg yield_lower yield_upper
predict res_lower, res
reg yield_upper yield_lower
predict res_upper, res

metobit emph yield || policy: yield, vce(r) ll(0)
est sto M1
metobit emph c.yield#i.party ibn.party, nocons || policy: yield, vce(r) ll(0)
est sto M2
metobit emph yield_female c.res_male || policy: yield_female, vce(r) ll(0)
est sto M3
metobit emph yield_male c.res_female || policy: yield_male, vce(r) ll(0)
est sto M4
metobit emph yield_lower c.res_upper || policy: yield_lower, vce(r) ll(0)
est sto M5
metobit emph yield_upper c.res_lower || policy: yield_upper, vce(r) ll(0)
est sto M6
metobit emph c.yield_female#i.party c.res_male#i.party ibn.party, nocons || policy: yield_female, vce(r) ll(0)
est sto M7
metobit emph c.yield_male#i.party c.res_female#i.party ibn.party, nocons || policy: yield_male, vce(r) ll(0)
est sto M8
metobit emph c.yield_lower#i.party c.res_upper#i.party ibn.party, nocons || policy: yield_lower, vce(r) ll(0)
est sto M9
metobit emph c.yield_upper#i.party c.res_lower#i.party ibn.party, nocons || policy: yield_upper, vce(r) ll(0)
est sto M10

estout M1 M2 using "files\table2.doc", /*
*/ cells(b(fmt(2) star) se(par fmt(2))) starlevels(+ 0.10 * 0.05 ** 0.01) stardrop(/:) replace
estout M3 M4 M5 M6 using "files\table3.doc", /*
*/ cells(b(fmt(2) star) se(par fmt(2))) starlevels(+ 0.10 * 0.05 ** 0.01) stardrop(/:) replace
estout M7 M8 M9 M10 using "files\table4.doc", /*
*/ cells(b(fmt(2) star) se(par fmt(2))) starlevels(+ 0.10 * 0.05 ** 0.01) stardrop(/:) replace
